/* FILE: mscrnhdr.h                             (D. Tottingham  03/24/91)

This is an include file of the defines, data structure definitions and
external data declarations for the mscrnhdr module.

*/

#ifndef _MSCRNHDR_
#define _MSCRNHDR_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"
#include "mutils.h"
#include "mvideo.h"


/************************************************************************
                                DEFINES

************************************************************************/
#define MAX_STORAGE_STAT_LENGTH 10

/* Event Status Bits */
#define H_ASLEEP                0x0010
#define H_AUTOTRIGGER_ENABLED   0x0008
#define H_FREE_RUN              0x0004
#define H_RECORD_CALIBRATION    0x0002
#define H_RECORD_EVENT          0x0001

/* Header Constants */
#define HDR1_I1                 5
#define HDR1_I2                 18
#define HDR2_I1                 ((MAXI) - 8)
#define BCKGND_COLOR            BLACK
#define HEADER_COLORS           YELLOW, BCKGND_COLOR, BCKGND_COLOR


/************************************************************************
                        STRUCTURE DEFINITIONS


************************************************************************/
typedef unsigned short          BIT_MAP;

typedef struct {
        char           *milestone;
        BIT_MAP        event_status;
        char           storage_status[MAX_STORAGE_STAT_LENGTH];
        int            event_ctr;
        unsigned int   bankswitch_ctr;
        U_ELAPSED_TIME uptime;
} H_STATUS;



/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC void h_increment_bankswitch_ctr ();
PUBLIC void h_increment_event_ctr ();
PUBLIC void h_initialize_params ();
PUBLIC void h_initialize_path (char *);
PUBLIC void h_set_event_ctr (int);
PUBLIC void h_set_trigger_status (int);
PUBLIC void h_set_uptime ();
PUBLIC void h_toggle_status (int);
PUBLIC void h_update ();

#endif
